#ifndef __CBool__
#define __CBool__

//	===========================================================================

#include "CString.hpp"

//	===========================================================================

using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CBool CBool.hpp
		 * @brief Wrapper around bool type
		 *
		 * CBool is a wrapper class around a boolean type giving it CCountedObject functionality to a built in type
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Fixed const correctness for the equality / inequality operators
		 * @version 1.0.2 Added inplace get as string function
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CBool.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CBool : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param value The value to default to
			 */
			CBool(const bool value = false);

			/**
			 * Destruction
			 */
			virtual ~CBool();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CBool& A reference to this
			 */
			CBool &operator = (const CBool &value);

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CBool& A reference to this
			 */
			CBool &operator = (const bool value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if booleans are equal, false otherwise
			 */
			bool operator == (const CBool &value) const;

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if booleans are equal, false otherwise
			 */
			bool operator == (const bool value) const;

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if booleans are inequal, false otherwise
			 */
			bool operator != (const CBool &value) const;

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if booleans are inequal, false otherwise
			 */
			bool operator != (const bool value) const;

//	===========================================================================

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const CBool &value);

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const bool value);

			/**
			 * Get as a bool built in type
			 * @retval bool The value of the boolean
			 */
			bool getValue() const;

			/**
			 * Get as a string
			 * @retval CString The value as a CString - either "True" or "False"\n
			 */
			CString getValueAsString() const;

			/**
			 * Get as a string
			 * @param string The string to store the value in (either "True" or "False")
			 */
			void getValueAsString(CString &string) const;

//	===========================================================================

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const;

//	===========================================================================

		protected:

//	===========================================================================

			bool m_value;			/**< The value */
		};
	}
}
#endif	// End of CBool.hpp